﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Remoting;

namespace Client
{
	class ClientActionHandler : RActionHandler
	{
		public override void Do(string method, params object[] args)
		{
			Console.WriteLine("Invoke: {0} with args {1}", method, ToString(args));
		}

		private string ToString(object[] args)
		{
			StringBuilder result = new StringBuilder();
			bool first = true;
			foreach (object arg in args)
			{
				if(!first)
					result.Append(", ");
				first = false;
				result.AppendFormat("{0}", arg);
			}
			return result.ToString();
		}
	}
}
